package com.androidbook.filesoc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class ViewLogActivity extends Activity {

	public static final String LOG_FILENAME = "Chat_Log.txt";

	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
		setContentView(R.layout.showfile);

		final TextView log = (TextView) findViewById(R.id.TextViewCurrentLogFile);
				
		// Pobranie zawartości plikuk, wyświetlenie jej w kontrolce TextView
		
        try {
        	InputStream iFile = (InputStream) openFileInput(LOG_FILENAME);
        	log.setText(inputStreamToString(iFile));
		} catch (Exception e) {
			log.setText("Couldn't read log file.");
		}	
		
		// Obsługa przycisku Usuń plik.
		final Button clearLog = (Button) findViewById(R.id.ButtonClearLog);
		clearLog.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Jeśli plik istnieje, usuwamy go.
				if (java.util.Arrays.binarySearch(fileList(), LOG_FILENAME) != (-1)) {
					deleteFile(LOG_FILENAME);
				}
				
				// Aktualizacja ekranu aplikacji.
				final TextView log = (TextView) findViewById(R.id.TextViewCurrentLogFile);
	        	log.setText(null);
			}
		});

		// Obsługa przycisku Pogawędk.
		final Button goChat = (Button) findViewById(R.id.ButtonChat);
		goChat.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Przejście do innej aktywności, która pozwala na prowadzenie pogawędek.
	        	Intent intent = new Intent(ViewLogActivity.this, FileStreamOfConsciousnessActivity.class);
	   			startActivity(intent);

			}
		});
	}

	// Konwersja strumienia wejściowego do postaci łańcucha znaków, dzięki czemu 
	// będzie można zapisać jego zawartość w kontrolce TextView. 
	// Zazwyczaj potencjalnie długotrwałe operacje tego typu będą wykonywane w osobnym wątku,
	// a aplikacja będzie prezentować ich przebieg przy użyciu jakiegoś paska postępów.
	// Jednak w tym przykładzie zależy nam na zachowaniu jak największej prostoty i czytelności,
	// gdyż nasza aplikacja do pogawędek jest bardzo mała. 
	// Przykład wykonywania operacji w innym wątku można znaleźć w pliku
	// FileStreamOfConsciousness.java, a konkretnie w metodzie logChatMessage().
	
	public String inputStreamToString(InputStream is) throws IOException {
		StringBuffer sBuffer = new StringBuffer();
		DataInputStream dataIO = new DataInputStream(is);
		String strLine = null;

		while ((strLine = dataIO.readLine()) != null) {
			sBuffer.append(strLine + "\n");
		}

		dataIO.close();
		is.close();

		return sBuffer.toString();

	}
}
